package gov.va.vamf.scheduling.varutility.service;


import gov.va.vamf.scheduling.varutility.datalayer.ClinicalServicesRepository;
import gov.va.vamf.scheduling.varutility.domain.ClinicalServices;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

import static gov.va.vamf.scheduling.varutility.utils.VarUtilityConstants.EXPRESS_CARE_ID;

@Service
public class ClinicalServicesService {

    @Autowired
    private ClinicalServicesRepository clinicalServicesRepository;


    public List<ClinicalServices> fetch() {
        return clinicalServicesRepository.findAll();
    }

    public List<ClinicalServices> fetchForDirectScheduling() {
        return clinicalServicesRepository.findByIdNot(EXPRESS_CARE_ID);
    }

    public List<ClinicalServices> fetchForRequest() {
        return clinicalServicesRepository.findByIdNot(EXPRESS_CARE_ID);
    }

    public List<ClinicalServices> fetchForCustomRequest() {
        return clinicalServicesRepository.findById(EXPRESS_CARE_ID);
    }

    public List<ClinicalServices> fetchById(String id) {
        return clinicalServicesRepository.findById(id);
    }
}
